#version 430

layout (location = 0) in vec3 noiseCoords;

layout (location = 0) out vec4 gAlbedoSpec;

const mat2 myt = mat2(.12121212, .13131313, -.13131313, .12121212);
const vec2 mys = vec2(1e4, 1e6);

vec2 rhash(vec2 uv) {
  uv *= myt;
  uv *= mys;
  return fract(fract(uv / mys) * uv);
}

vec3 hash(vec3 p) {
  return fract(
      sin(vec3(dot(p, vec3(1.0, 57.0, 113.0)), dot(p, vec3(57.0, 113.0, 1.0)),
               dot(p, vec3(113.0, 1.0, 57.0)))) *
      43758.5453);
}

vec3 voronoi3d(const in vec3 x) {
  vec3 p = floor(x);
  vec3 f = fract(x);

  float id = 0.0;
  vec2 res = vec2(100.0);
  for (int k = -1; k <= 1; k++) {
    for (int j = -1; j <= 1; j++) {
      for (int i = -1; i <= 1; i++) {
        vec3 b = vec3(float(i), float(j), float(k));
        vec3 r = vec3(b) - f + hash(p + b);
        float d = dot(r, r);

        float cond = max(sign(res.x - d), 0.0);
        float nCond = 1.0 - cond;

        float cond2 = nCond * max(sign(res.y - d), 0.0);
        float nCond2 = 1.0 - cond2;

        id = (dot(p + b, vec3(1.0, 57.0, 113.0)) * cond) + (id * nCond);
        res = vec2(d, res.x) * cond + res * nCond;

        res.y = cond2 * d + nCond2 * res.y;
      }
    }
  }

  return vec3(sqrt(res), abs(id));
}


uniform float time;
uniform float offset;
uniform float lifetimeTrans;
uniform vec3 playerColor;
void main(){

	if(lifetimeTrans > 0.0){

		 float transparency;

		vec3 timeVector = vec3(0.0, time, 0.0);

		if(offset == 0.0){
			transparency = voronoi3d(vec3(timeVector - noiseCoords * 5.0f)).x;
		}

		if(offset == 1.0){
			transparency = voronoi3d(vec3(timeVector + noiseCoords * 5.0f)).x;
		}

		transparency = (transparency - 0.5) * 2.0;
		
		transparency = clamp(transparency, 0.0, 1.0);

		//transparency = pow(transparency, 5) * 3.0;

		//transparency = clamp(transparency, 0.0, 1.0);

		gAlbedoSpec.xyzw = vec4(playerColor, transparency * lifetimeTrans * 0.6);
	}
}